// $Id: CKnob.cpp,v 1.6 2007/03/03 02:59:20 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CKnob.hpp"
using Exponent::GUI::Controls::CKnob;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CKnob, CAnimation);

//	===========================================================================
CKnob::CKnob(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener) 
	 : CAnimation(root, uniqueId, area)
	 , m_defaultValue(0.5)
	 , m_dragStartValue(0.0)
	 , m_coefficient(0.0)
	 , m_drag(false)
{
	EXPONENT_CLASS_CONSTRUCTION(CKnob);
	this->setDefaultValue(0.5);
	this->registerActionListener(listener);
	this->controlIsMouseEnabled(true);

	m_drag			 = false;
	m_dragStartValue = 0.0;
	m_coefficient	 = 0.005;
}

//	===========================================================================
CKnob::~CKnob()
{
	EXPONENT_CLASS_DESTRUCTION(CKnob);
}

//	===========================================================================
void CKnob::handleLeftButtonDown(CMouseEvent &event)
{
	m_drag			 = true;
	m_dragStartPoint = event.getMousePosition();
	m_dragStartValue = m_value;
	m_coefficient	 = 0.005;
	m_rootControl->lockControl(this);
}

//	===========================================================================
void CKnob::handleLeftButtonUp(CMouseEvent &event)
{
	m_drag = false;
	m_dragStartPoint.setPoint(0, 0);
	m_rootControl->unlockControl();
}

//	===========================================================================
void CKnob::handleDoubleClick(CMouseEvent &event)
{
	this->setValue(m_defaultValue);
	this->update();

	// Thanks to caco for spotting that this should be here
	if (m_actionListener)
	{
		m_actionListener->handleActionEvent(CActionEvent(this));
	}
}

//	===========================================================================
void CKnob::handleMouseScroll(CMouseEvent &event)
{
	const double oldValue = m_value;
	if (event.getWheelMovementAmount() > 0.0)
	{
		if (event.isShiftDown())
		{
			m_value += 0.00625;
		}
		else
		{
			m_value += 0.025;
		}
	}
	else
	{
		if (event.isShiftDown())
		{
			m_value -= 0.00625;
		}
		else
		{
			m_value -= 0.025;
		}
	}

	CBounds::clampRange(m_value, 0.0, 1.0);
	if (m_value != oldValue)
	{
		this->update();
		if (m_actionListener)
		{
			m_actionListener->handleActionEvent(CActionEvent(this));
		}
	}
}

//	===========================================================================
void CKnob::handleMouseMovement(CMouseEvent &event)
{
	if (m_drag)
	{
		// Store the original value
		const double oldValue = m_value;

		// Obtain the distance travelled
		const long difference = (m_dragStartPoint.getYPosition() - event.getMousePosition().getYPosition()) + (event.getMousePosition().getXPosition() - m_dragStartPoint.getXPosition());

		// Calculate the range of the dial
		double range = 200.0;
		if (event.isShiftDown())
		{
			range = 2000.0;
		}

		// Store an incremental value
		//const double zoom	   = 1.5;
		const double increment = 1.0 / range;

		// Linear interpolation...
		m_dragStartValue += difference * (m_coefficient - increment);
		m_coefficient = increment;
		m_value = m_dragStartValue + difference * m_coefficient;

		// Bounds check and notify
		CBounds::clampRange(m_value, 0.0, 1.0);
		if (m_value != oldValue)
		{
			this->update();
			if (m_actionListener)
			{
				m_actionListener->handleActionEvent(CActionEvent(this));
			}
		}
	}
}